unit NewPresentDialog;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
     Buttons, ExtCtrls,
     MainData, jpeg;
type
  TOKBottomDlg = class(TForm)
    OkBtn : TButton;
    CancelBtn : TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    cbBoxSlideSize: TComboBox;
    LbPresentName: TLabel;
    Label4: TLabel;
    procedure OkBtnClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OKBottomDlg : TOKBottomDlg;

implementation

{$R *.dfm}

procedure TOKBottomDlg.OkBtnClick(Sender: TObject);
begin
   PresentationName := Trim(Edit1.Text);
end;
// -------------------------------------------------------------------------
// 01.11.2016
function VerifyName(var RqName : string) : boolean;
const DelSimbArr : array[1..16] of Char =
(',', ':', ';', '@',  '$', '^', '&', '*',
 '\', '|', '/', '=', '''', '"', '~', '`');
var wStr        : string;
    Ind1, Ind2  : integer;
begin
   Result := True;
   wStr   := RqName;
   if Length(wStr) = 0
   then begin
     wStr := ' ';
     Result := False;
   end;
   for Ind1 := 1 to Length(wStr) do
       for Ind2 := Low(DelSimbArr) to High(DelSimbArr)
       do if wStr[Ind1] = DelSimbArr[Ind2]
          then begin
                wStr[Ind1] := '_';
                Result := False;
          end;
   RqName := wStr;
end;
// -------------------------------------------------------------------------
// 01.11.2016
procedure TOKBottomDlg.Edit1Change(Sender: TObject);
var wStr : string;
begin
     wStr := Edit1.Text;
     if  not VerifyName(wStr) then Edit1.Text := wStr;
     LbPresentName.Caption := wStr;
end;
// -------------------------------------------------------------------------
// 01.11.2016
procedure TOKBottomDlg.FormCreate(Sender: TObject);
begin
     Edit1.Text := ' ';
     LbPresentName.Caption := Edit1.Text;
end;

end.
